/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiCustomRenderRegister;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import net.minecraft.class_1937;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public class ServerLevelWrapper
implements IServerLevelWrapper {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final Map<class_3218, WeakReference<ServerLevelWrapper>> LEVEL_WRAPPER_REF_BY_SERVER_LEVEL = Collections.synchronizedMap(new WeakHashMap());
    private final class_3218 level;
    private IDhLevel dhLevel;
    private final String KeyedLevelDimensionName;

    public static ServerLevelWrapper getWrapper(class_3218 level) {
        return (ServerLevelWrapper)LEVEL_WRAPPER_REF_BY_SERVER_LEVEL.compute(level, (newLevel, levelRef) -> {
            ServerLevelWrapper oldLevelWrapper;
            if (levelRef != null && (oldLevelWrapper = (ServerLevelWrapper)levelRef.get()) != null) {
                return levelRef;
            }
            return new WeakReference<ServerLevelWrapper>(new ServerLevelWrapper((class_3218)newLevel));
        }).get();
    }

    public ServerLevelWrapper(class_3218 level) {
        this.level = level;
        this.KeyedLevelDimensionName = this.createKeyedLevelDimensionName();
    }

    @Override
    public File getMcSaveFolder() {
        return this.level.method_14178().method_17981().field_17664.toFile();
    }

    @Override
    public String getKeyedLevelDimensionName() {
        return this.KeyedLevelDimensionName;
    }

    private String createKeyedLevelDimensionName() {
        String dimensionName = this.getDhIdentifier();
        if (Config.Server.sendLevelKeys.get().booleanValue()) {
            Object levelKeyPrefix = Config.Server.levelKeyPrefix.get();
            if (SharedApi.getEnvironment() == EWorldEnvironment.CLIENT_SERVER) {
                String cleanWorldFolderName = this.getWorldFolderName().replaceAll("[^a-zA-Z0-9-_ ]", "").replaceAll(" ", "_");
                levelKeyPrefix = (String)levelKeyPrefix + (!((String)levelKeyPrefix).isEmpty() ? "_" : "") + cleanWorldFolderName + "_" + this.getHashedSeedEncoded();
            }
            if (((String)levelKeyPrefix).isEmpty()) {
                levelKeyPrefix = this.getHashedSeedEncoded();
            }
            String mainPart = "@" + dimensionName;
            return ((String)levelKeyPrefix).substring(0, Math.min(150 - mainPart.length(), ((String)levelKeyPrefix).length())) + mainPart;
        }
        return dimensionName;
    }

    private String getWorldFolderName() {
        try {
            return this.level.method_8503().method_3847((class_5321)class_1937.field_25179).method_14178().method_17981().field_17664.getParent().getFileName().toString();
        }
        catch (Exception e) {
            LOGGER.warn("Unable to get world folder name. LODs may not load or save correctly. Error: [" + e.getMessage() + "].", e);
            return "unknown_world";
        }
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.method_8597(), this.getDimensionName());
    }

    @Override
    public String getDimensionName() {
        return this.level.method_27983().method_29177().method_12832();
    }

    @Override
    public long getHashedSeed() {
        return this.level.method_22385().field_20641;
    }

    @Override
    public String getDhIdentifier() {
        return this.getDimensionName();
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.SERVER_LEVEL;
    }

    public class_3218 getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.method_8597().comp_643();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.method_8597().comp_642();
    }

    @Override
    public int getMaxHeight() {
        return this.level.method_31605();
    }

    @Override
    public int getMinHeight() {
        return this.level.method_31607();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.method_8393(pos.getX(), pos.getZ())) {
            return null;
        }
        class_2791 chunk = this.level.method_8402(pos.getX(), pos.getZ(), class_2806.field_12803, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, this);
    }

    public class_3218 getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_REF_BY_SERVER_LEVEL.remove(this.level);
    }

    @Override
    public void setDhLevel(IDhLevel dhLevel) {
        this.dhLevel = dhLevel;
    }

    @Override
    @Nullable
    public IDhLevel getDhLevel() {
        return this.dhLevel;
    }

    @Override
    public IDhApiCustomRenderRegister getRenderRegister() {
        if (this.dhLevel == null) {
            return null;
        }
        return this.dhLevel.getGenericRenderer();
    }

    @Override
    public File getDhSaveFolder() {
        if (this.dhLevel == null) {
            return null;
        }
        return this.dhLevel.getSaveStructure().getSaveFolder(this);
    }

    public String toString() {
        return "Wrapped{" + this.level.toString() + "@" + this.getDhIdentifier() + "}";
    }
}

