/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.file.structure.ClientOnlySaveStructure;
import com.seibel.distanthorizons.core.level.DhClientLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.multiplayer.client.ClientNetworkState;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.EventLoop;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class DhClientWorld
extends AbstractDhWorld
implements IDhClientWorld {
    private final ConcurrentHashMap<IClientLevelWrapper, DhClientLevel> levels;
    public final ClientOnlySaveStructure saveStructure;
    public final ClientNetworkState networkState = new ClientNetworkState();
    public final ExecutorService dhTickerThread = ThreadUtil.makeSingleThreadPool("Client World Ticker");
    public final EventLoop eventLoop = new EventLoop(this.dhTickerThread, this::_clientTick);

    public DhClientWorld() {
        super(EWorldEnvironment.CLIENT_ONLY);
        this.saveStructure = new ClientOnlySaveStructure();
        this.levels = new ConcurrentHashMap();
        LOGGER.info("Started DhWorld of type " + (Object)((Object)this.environment), new Object[0]);
    }

    @Override
    public DhClientLevel getOrLoadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IClientLevelWrapper)) {
            return null;
        }
        return this.levels.computeIfAbsent((IClientLevelWrapper)wrapper, clientLevelWrapper -> {
            try {
                return new DhClientLevel(this.saveStructure, (IClientLevelWrapper)clientLevelWrapper, this.networkState);
            }
            catch (Exception e) {
                LOGGER.fatal("Failed to load client level, error: [" + e.getMessage() + "].", e);
                ClientApi.INSTANCE.showChatMessageNextFrame("\u00a7cDistant Horizons: Client level loading failed.\u00a7r \nUnable to load level [" + clientLevelWrapper.getDhIdentifier() + "], LODs may not appear. See log for more information.");
                return null;
            }
        });
    }

    @Override
    public DhClientLevel getLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IClientLevelWrapper)) {
            return null;
        }
        return this.levels.get(wrapper);
    }

    @Override
    public Iterable<? extends IDhLevel> getAllLoadedLevels() {
        return this.levels.values();
    }

    @Override
    public int getLoadedLevelCount() {
        return this.levels.size();
    }

    @Override
    public void unloadLevel(@NotNull ILevelWrapper wrapper) {
        if (!(wrapper instanceof IClientLevelWrapper)) {
            return;
        }
        if (this.levels.containsKey(wrapper)) {
            LOGGER.info("Unloading level " + this.levels.get(wrapper), new Object[0]);
            wrapper.onUnload();
            this.levels.remove(wrapper).close();
        }
    }

    private void _clientTick() {
        this.levels.values().forEach(DhClientLevel::clientTick);
    }

    @Override
    public void clientTick() {
        this.eventLoop.tick();
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
        super.addDebugMenuStringsToList(messageList);
        this.networkState.addDebugMenuStringsToList(messageList);
    }

    @Override
    public void close() {
        this.networkState.close();
        this.dhTickerThread.shutdownNow();
        ArrayList closeFutures = new ArrayList();
        for (DhClientLevel dhClientLevel : this.levels.values()) {
            IClientLevelWrapper clientLevelWrapper = dhClientLevel.getClientLevelWrapper();
            if (clientLevelWrapper != null) {
                clientLevelWrapper.onUnload();
            }
            CompletableFuture closeFuture = new CompletableFuture();
            Thread closeThread = new Thread(() -> {
                dhClientLevel.close();
                closeFuture.complete(null);
            }, "level shutdown");
            closeThread.start();
            closeFutures.add(closeFuture);
        }
        for (CompletableFuture completableFuture : closeFutures) {
            completableFuture.join();
        }
        this.levels.clear();
        this.eventLoop.close();
        LOGGER.info("Closed DhWorld of type [" + (Object)((Object)this.environment) + "].", new Object[0]);
    }
}

